unit CU30DLL;

{$Align on}

Interface

uses
  Windows,
  SysUtils,
  Classes;

type PChar16 = array[0..31] of char;
     PChar32 = array[0..31] of char;
     PChar256 = array[0..255] of char;

     USBEEProm = record
        USBVendorID:   dword;
        USBProductID:  dword;
        USBDeviceID:   dword;
        DeviceID:      dword;
        EEPromID:      dword;
        Version:       dword;
        SerialNumber:  dword;
        CustomerID:    dword;
        Company:       PChar16;
        Date:          PChar16;
        ProductStr:    PChar32;
        Customer:      PChar32;
        CustomerStr:   PChar32;
     end;

     ByteRec64 = Array [0..63] of Byte;
     ByteRec1024 = Array [0..1024] of Byte;
     ByteRec8192 = Array [0..8191] of Byte;
     InfoRec = record Vendor,Product,Device,DeviceID,EEPromID,USB,Hnd,Res:dword; end;
     DeviceRec = record USBInstance,USBVersion,DevID,EEID:dword; end;

function  GetUSBEEPromInfo(MUSBDeviceID:DeviceRec): USBEEProm; stdcall
{Input:  DeviceRec as created by CU30Open
         (valid also for all following commands)
 returnes EEProm content in the record USBEEProm }

function  Echo(MUSBDeviceID:DeviceRec;w: dword):dword; stdcall
{returns arbitrary dword}

function  CU30Open(var MUSBDeviceID:DeviceRec):PChar256;  stdcall
{Input:  DeviceRec:  USBInstance,USBVersion,DevID,EEID:dword;
         USBInstance is returned by the routine (0..15)
         EEID identifies the device to be adressed (0..15)
         The parameters USBVersion,DevID are already preset for
         the device CU30 (wrong inputs are overwritted).
 Output: Error message as 0-terminated string
         If no error had occured the string remains empty}

procedure CU30Close(MUSBDeviceID:DeviceRec);  stdcall
{Closes USB device}

procedure CU30PiezoStop(MUSBDeviceID:DeviceRec);   stdcall
{Terminates any movement}

procedure CU30DCDCon(MUSBDeviceID:DeviceRec); stdcall
procedure CU30DCDCoff(MUSBDeviceID:DeviceRec); stdcall
{Switches DCDC-Converter for piezodrives on and off}

procedure CU30Move(MUSBDeviceID:DeviceRec;Axis,Speed,TimeOut:longint); stdcall
{Move Axis 1,2, or 3 with Speed -1000..1000
 TimeOut 1..254 controls time after which the command is terminated.
 For TimeOut=255 automatic termination does not occur
 If contineous movement is required, the command has to be resend with a
 period higher than the timeout period (Timeout=1..254). Alternatively the
 command has to be send once with TimeOut=255
 Movement can be stopped any time by sending CU30PiezoStop }

procedure CU30Step(MUSBDeviceID:DeviceRec;Axis,Speed,Steps:longint); stdcall
{Step Axis 1,2, or 3 with Speed -1000..1000 for 1..16777215 Steps
 The command will terminate after the required time. Whether termination
 has already accured can be tested with CU30TestReady.
 The command can be stopped by sending CU30PiezoStop }

function  CU30TestReady(MUSBDeviceID:DeviceRec):dword; stdcall
{Returns 0 if previous command is still running, 1 if it is
 already finished}


implementation

function  GetUSBEEPromInfo;      external 'CU30.DLL'
function  Echo;                  external 'CU30.DLL'
function  CU30Open;              external 'CU30.DLL'
procedure CU30Close;             external 'CU30.DLL'
procedure CU30PiezoStop;         external 'CU30.DLL'
procedure CU30DCDCon;            external 'CU30.DLL'
procedure CU30DCDCoff;           external 'CU30.DLL'
procedure CU30Move;              external 'CU30.DLL'
procedure CU30Step;              external 'CU30.DLL'
function  CU30TestReady;         external 'CU30.DLL'

end.



